/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.blockEntity;

import cc.tweaked_programs.cccbridge.BlockRegister;
import cc.tweaked_programs.cccbridge.peripherals.TargetBlockPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TargetBlockEntity
extends BlockEntity {
    private TargetBlockPeripheral peripheral;

    public TargetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegister.TARGET_BLOCK_ENTITY.get(), pos, state);
    }

    public void updateContent(int offset, List<String> content) {
        if (this.peripheral == null) {
            return;
        }
        int height = this.getHeight();
        int i = 0;
        String dot = Character.toString(183);
        for (String line : content) {
            if (i < height) {
                line = line.replaceAll("\u2588", "=");
                line = line.replaceAll("\u2592", "-");
                line = line.replaceAll("\u2591", dot);
                this.peripheral.replaceLine(offset + i, line);
            }
            ++i;
        }
    }

    public IPeripheral getPeripheral(Direction side) {
        if (this.peripheral == null) {
            this.peripheral = new TargetBlockPeripheral(this);
        }
        return this.peripheral;
    }

    public int getWidth() {
        if (this.peripheral == null) {
            return 1;
        }
        return this.peripheral.getWidth();
    }

    public int getHeight() {
        if (this.peripheral == null) {
            return 1;
        }
        return this.peripheral.getHeight();
    }
}

